/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: DMAStateDlg.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 30.10.09 15:15 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    DMA State Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.04.2007  RM       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file DMAStateDlg.cpp
///   DMA State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "DMAStateDlg.h"
#include "CifXTestDlg.h"

#define DEFAULT_SETDMASTATE_TIMEOUT  0

/////////////////////////////////////////////////////////////////////////////
/// DMA state elements for list control
/////////////////////////////////////////////////////////////////////////////
static struct DMA_STATEtag
{
  LPCTSTR       szState;  //!< State to display in control
  unsigned long ulState;  //!< State value for element
} s_atDMAState[] =
{
  {_T("DMA ON"),  CIFX_DMA_STATE_ON},
  {_T("DMA OFF"), CIFX_DMA_STATE_OFF},
};

IMPLEMENT_DYNAMIC(CDMAStateDlg, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CDMAStateDlg::CDMAStateDlg(CWnd* pParent /*=NULL*/)
	: CBaseDialog(CDMAStateDlg::IDD, pParent, false)
  , m_ulSetTimeout(DEFAULT_SETDMASTATE_TIMEOUT)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CDMAStateDlg::~CDMAStateDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CDMAStateDlg::DoDataExchange(CDataExchange* pDX)
{
  CBaseDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_CB_NEWSTATE, m_cNewStateCtrl);
}


BEGIN_MESSAGE_MAP(CDMAStateDlg, CBaseDialog)
  ON_BN_CLICKED(IDC_BTN_GETSTATE, OnBnClickedBtnGetstate)
  ON_BN_CLICKED(IDC_BTN_SETSTATE, OnBnClickedBtnSetstate)
  ON_EN_KILLFOCUS(IDC_EDT_TIMEOUT, OnEnKillfocusEdtTimeout)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
/// Button "Get DMA State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CDMAStateDlg::OnBnClickedBtnGetstate()
{
  uint32_t ulActState = 0;

  int32_t lRet = CcifXTestDlg::s_pcDevice->DMAState(CIFX_DMA_STATE_GETSTATE, &ulActState);

  CString csError;
  if(CIFX_NO_ERROR != lRet)
  {
    csError.Format(_T("0x%08X\r\n%s"),
                   lRet,
                   (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

  } else
  {
    CString csState;

    switch(ulActState)
    {
    case CIFX_DMA_STATE_OFF:
      csState = _T("DMA OFF");
      break;

    case CIFX_DMA_STATE_ON:
      csState = _T("DMA ON");
      break;

    default:
      csState = _T("Illegal DMA State");
      break;
    }

    SetDlgItemText(IDC_EDT_ACTSTATE, csState);
  }
  SetDlgItemText(IDC_LASTERR, csError);

}

/////////////////////////////////////////////////////////////////////////////
/// Button "Set DMA State" clicked event
/////////////////////////////////////////////////////////////////////////////
void CDMAStateDlg::OnBnClickedBtnSetstate()
{
  int iItem = m_cNewStateCtrl.GetCurSel();
  ASSERT(-1 != iItem);

  CWaitCursor cWait;

  uint32_t ulNewState = (unsigned long)m_cNewStateCtrl.GetItemData(iItem);
  uint32_t ulTemp     = 0;

  int32_t lRet = CcifXTestDlg::s_pcDevice->DMAState(ulNewState, &ulTemp);

  CString csError;
  if(CIFX_NO_ERROR != lRet)
  {
    csError.Format(_T("0x%08X\r\n%s"),
                   lRet,
                   (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

  }
  SetDlgItemText(IDC_LASTERR, csError);
}

/////////////////////////////////////////////////////////////////////////////
/// Set DMA State Timeout editing end event
/////////////////////////////////////////////////////////////////////////////
void CDMAStateDlg::OnEnKillfocusEdtTimeout()
{
  CString csTemp;
  GetDlgItemText(IDC_EDT_TIMEOUT, csTemp);

  TCHAR* pszEnd = NULL;
  m_ulSetTimeout = _tcstoul(csTemp, &pszEnd, 10);

  csTemp.Format(_T("%u"), m_ulSetTimeout);
  SetDlgItemText(IDC_EDT_TIMEOUT, csTemp);
}

/////////////////////////////////////////////////////////////////////////////
/// First Time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CDMAStateDlg::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  SetDlgItemInt(IDC_EDT_TIMEOUT, m_ulSetTimeout, FALSE);

  for(int iIdx = 0; iIdx < sizeof(s_atDMAState) / sizeof(s_atDMAState[0]); ++iIdx)
  {
    int iItem = m_cNewStateCtrl.AddString(s_atDMAState[iIdx].szState);
    m_cNewStateCtrl.SetItemData(iItem, s_atDMAState[iIdx].ulState);
  }

  m_cNewStateCtrl.SetCurSel(0);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Cyclic Function (unused)
/////////////////////////////////////////////////////////////////////////////
void CDMAStateDlg::ThreadFunction()
{
  //not needed, as we have no cyclic actions to perform
}

/////////////////////////////////////////////////////////////////////////////
/// Device changed in Main Dialog
///   \param pcDevice new Device (NULL if device was closed)
/////////////////////////////////////////////////////////////////////////////
void CDMAStateDlg::OnUpdateDevice(CCifXDeviceBase* pcDevice)
{
  if(NULL != pcDevice)
    OnBnClickedBtnGetstate();
}
